
Type Demo8Screen Extends TScreen
	
	Field border:TBorder
	Field agent:TAgent
	
	Field redCircles:TCircles[]
	Field blueCircles:TCircles[]
	Field greenCircles:TCircles[]
	Field blackCircles:TCircles[]
	
	Method Draw(delta:Float)
		border.Draw()
		agent.Draw()
		
		For Local c:TCircles = EachIn redCircles
			c.Draw()
		Next
	
		For Local c:TCircles = EachIn blueCircles
			c.Draw()
		Next

		For Local c:TCircles = EachIn greenCircles
			c.Draw()
		Next
		
		For Local c:TCircles = EachIn blackCircles
			c.Draw()
		Next
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
	End Method
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
			_firstRun = False
		EndIf
		HandleKeyboardInput()
		HandleMouseInput()
		physics.Update(delta)
	End Method
	
	Method Load()
		physics = TPhysicsSimulator.Create(Vector2.Zero())
		physics.SetMaxContactsToDetect(2)
		view = TPhysicsSimulatorView.Create(physics)
		view.JustShowPerformancePanel()
		Local borderWidth:Int = TDemo.gfxHeight *.05
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2, TDemo.gfxHeight / 2)
		
		border = TBorder.Create(TDemo.gfxWidth, TDemo.gfxHeight, borderWidth, center)
		border.Load(physics)
		
		agent = TAgent.Create(center)
		agent.SetCollisionCategories(CollisionCategories.All)
		agent.SetCollidesWith(CollisionCategories.All & ~CollisionCategories.Cat4)
		agent.Load(physics)
		
		LoadCircles()
	End Method
	
	Method LoadCircles()
		Local startPosition:Vector2
		Local endPosition:Vector2
		
		redCircles = New TCircles[10]
		blueCircles = New TCircles[10]
		blackCircles = New TCircles[10]
		greenCircles = New TCircles[10]
		
		startPosition = Vector2.Create(50, 50)
		endPosition = Vector2.Create(TDemo.gfxWidth - 50, 50)
		
		Local balls:Int = 40
		Local ySpacing:Float = 12
		For Local i:Int = 0 To redCircles.Length - 1
			redCircles[i] = TCircles.Create(startPosition, endPosition, balls, 5, TColor.Create(175, 200, 0, 0), TColor.Black)
			redCircles[i].SetCollisionCategories(CollisionCategories.Cat1)
			redCircles[i].SetCollidesWith(CollisionCategories.Cat5)
			redCircles[i].Load(physics)
			startPosition.Y:+ySpacing
			endPosition.Y:+ySpacing
		Next
		
		startPosition.Y:+2 * ySpacing
		endPosition.Y:+2 * ySpacing
		
		For Local i:Int = 0 To blueCircles.Length - 1
			blueCircles[i] = TCircles.Create(startPosition, endPosition, balls, 5, TColor.Create(175, 0, 0, 200), TColor.Black)
			blueCircles[i].SetCollisionCategories(CollisionCategories.Cat3)
			blueCircles[i].SetCollidesWith(CollisionCategories.Cat5)
			blueCircles[i].Load(physics)
			startPosition.Y:+ySpacing
			endPosition.Y:+ySpacing
		Next
		
		startPosition.Y:+12 * ySpacing
		endPosition.Y:+12 * ySpacing
		
		For Local i:Int = 0 To greenCircles.Length - 1
			greenCircles[i] = TCircles.Create(startPosition, endPosition, balls, 5, TColor.Create(175, 0, 200, 0), TColor.Black)
			greenCircles[i].SetCollisionCategories(CollisionCategories.Cat2)
			greenCircles[i].SetCollidesWith(CollisionCategories.Cat5)
			greenCircles[i].Load(physics)
			startPosition.Y:+ySpacing
			endPosition.Y:+ySpacing
		Next
		
		startPosition.Y:+2 * ySpacing
		endPosition.Y:+2 * ySpacing
		
		For Local i:Int = 0 To blackCircles.Length - 1
			blackCircles[i] = TCircles.Create(startPosition, endPosition, balls, 5, TColor.Create(175, 0, 0, 0), TColor.Black)
			blackCircles[i].SetCollisionCategories(CollisionCategories.Cat4)
			blackCircles[i].SetCollidesWith(CollisionCategories.Cat5)
			blackCircles[i].Load(physics)
			startPosition.Y:+ySpacing
			endPosition.Y:+ySpacing
		Next
	End Method
	
	Method Unload()
		
	End Method
	
	Method OnEscapeKeyHit()
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
	End Method
	
	Method GetTitle:String()
		Return "Broad Phase Collision Stress Test"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo simply stress tests broad phase collision")
		sb.AppendLine("In this demo:")
		sb.AppendLine("Narrow phase collision is disabled between")
		sb.AppendLine(" all balls.")
		sb.AppendLine("")
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		sb.AppendLine("")
		sb.AppendLine("Mouse")
		sb.AppendLine("  -Hold down left button and drag")
		Return sb
	End Method
	
	Method HandleKeyboardInput()
		Local forceAmount:Float = 1000
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		agent.agentBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 14000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		agent.agentBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
End Type
